<%@ page language="java" import="java.util.*" pageEncoding="gbk" %>
<!DOCTYPE html>
<html>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=gbk"/>
    <%@include file="../../../../../../frame/assets/header-all.jsp" %>
    <link rel="stylesheet" type="text/css" href="../../../../resource/css/map.frame.css">
</head>
<body class="easyui-layout" onselectstart="return false">
<div data-options="region:'north'" id='north' style="height: 78px;border: none">
    <div class="left-box fl">
        <div>
            <span class="text-content">豸</span>
            <select id="lb" class="easyui-combobox">
                <option value="">ȫ</option>
                <option value="1" selected></option>
                <option value="2"></option>
                <option value="3">źŵ</option>
                <option value="4">յ</option>
                <option value="10">ش</option>
                <option value="11">΢</option>
                <option value="12">״</option>
                <option value="13"></option>
            </select>
        </div>
        <div>
            <span class="text-content">豸ƣ</span>
            <input class="easyui-textbox" id="LIKEsbmc" prompt='Ż'>
        </div>
        <div>
            <span class="text-content">豸״̬</span>
            <input class="easyui-combobox" id="state" prompt='ѡ״̬'  data-options="valueField:'id', textField:'text',panelHeight:'auto'">
        </div>
    </div>

    <div class="right-box fl">
        <button id="search" class="button-search" onclick="doSearch()">ѯ</button>
    </div>
</div>

<div data-options="region:'center',split:false" class="easyui-layout" style="border: none">
    <table id="monitor-tab-grid"></table>
</div>
<div data-options="region:'south',height:70,borer:false,collapsible:true" class="easyui-layout" id='southPanel'>
    <div style="height:100%;margin:0 auto;" id="GridListDiv">
        <table id="statisgrid" cellspacing="0" width="100%" cellpadding="0" border="1" align="center"
               style="text-align:center;margin:0 auto;">
            <thead>
            <tr>
                <td></td>
                <td></td>
                <td>쳣</td>
                <td>ά</td>
                <td>Ѿά</td>
            </tr>
            </thead>
            <tbody id='searchGridList'>
            </tbody>
        </table>
    </div>
</div>

<script type="text/javascript">
    $(function () {
        $.fn.pagination.defaults.beforePageText = '';
        $.fn.pagination.defaults.afterPageText = '';
        $.fn.pagination.defaults.showPageList = false;
        $.fn.pagination.defaults.showRefresh = false;
        //ѡ豸״̬ѡ
        var machineArr = [], videoArr = [], ledArr = [], xhdArr = [], detectorArr = [], zxldArr = [];
        videoArr.push({"id": '', "text":""});
        machineArr.push({"id": '', "text":""});
        ledArr.push({"id": '', "text":""});
        xhdArr.push({"id": '', "text":""});
        detectorArr.push({"id": '', "text":""});
        zxldArr.push({"id": '', "text":""});
        $.ajax({
            url: " xtclAction!query_Xtcl_task.do",
            type: "post",
            dataType: "JSON",
            async: false,
            data: {
                "csdl": "ywMachineCurrentState,ywVideoCurrentState,nhywjtledydpglCurrentState,nhywjtxhdglCurrentState," +
                    "ksh_detectorCurrentState,ksh_ZxldCurrentState"
            },
            success: function (res) {
                if (res && res.length > 0) {
                    for (i in res) {
                        if (res[i].csdl == "ywMachineCurrentState") {
                            machineArr.push({"id": res[i].csdm, "text": res[i].csmc});
                        } else if (res[i].csdl == "ywVideoCurrentState") {
                            videoArr.push({"id": res[i].csdm, "text": res[i].csmc});

                        } else if (res[i].csdl == "nhywjtledydpglCurrentState") {
                            ledArr.push({"id": res[i].csdm, "text": res[i].csmc});

                        } else if (res[i].csdl == "nhywjtxhdglCurrentState") {

                            xhdArr.push({"id": res[i].csdm, "text": res[i].csmc});

                        } else if (res[i].csdl == "ksh_detectorCurrentState") {

                            detectorArr.push({"id": res[i].csdm, "text": res[i].csmc});
                        } else if (res[i].csdl == "ksh_ZxldCurrentState") {
                            zxldArr.push({"id": res[i].csdm, "text": res[i].csmc});

                        }
                    }
                }
            }
        });
        $("#state").combobox("loadData", videoArr);

        $('#lb').combobox({
            onChange: function (newvalue, oldValue) {
                $('#state').combobox('clear');
                $('#state').combobox('loadData', {});//optionѡ
                if (newvalue == "1") {
                    $("#state").combobox("loadData", videoArr);

                } else if (newvalue == "2") {
                    $("#state").combobox("loadData", machineArr);
                } else if (newvalue == "3") {
                    $("#state").combobox("loadData", xhdArr);
                } else if (newvalue == "4") {
                    $("#state").combobox("loadData", ledArr);
                } else if (newvalue == "10" || newvalue == "11") {
                    $("#state").combobox("loadData", detectorArr);
                } else if (newvalue == "12") {
                    $("#state").combobox("loadData", zxldArr);
                }
            }
        });
        initGrid();
    });
    $('#monitor-tab-grid').datagrid({
        onClickRow :function(rowIndex,rowData){
           //ݾγϢλͼ
            var graphic=null;
            var point = {jd:rowData.jd, wd:rowData.wd};
            if(  $('#lb').combobox('getValue')=="1") {
                graphic= parent.MapUtil.getGraphic(point);
            }
            if(  $('#lb').combobox('getValue')=="3") {
                graphic = parent.MapUtil.getXhdGraphic(point);
            }else if(  $('#lb').combobox('getValue')=="4") {
                graphic = parent.MapUtil.getydpGraphic(point);
            }else if(  $('#lb').combobox('getValue')=="10") {
                graphic = parent.MapUtil.getdcGraphic(point);
            }
            else if(  $('#lb').combobox('getValue')=="11") {
                graphic = parent.MapUtil.getwbGraphic(point);
            } else if(  $('#lb').combobox('getValue')=="12") {
                graphic = parent.MapUtil.getldGraphic(point);
            }
            if(graphic!=null){
                parent.MapAPI.getMap().centerAt(graphic.geometry).then(function(){
                    parent.MapAPI.getMap().infoWindow.setTitle(graphic.getInfoTemplate().title);
                    parent.MapAPI.getMap().infoWindow.setContent(graphic.getInfoTemplate().content);
                    parent.MapAPI.getMap().infoWindow.show(graphic.geometry, parent.MapAPI.getMap().getInfoWindowAnchor(graphic.geometry));
                    parent.MapAPI.getMap().infoWindow.setFeatures([graphic]);
                });
            }
            else {
                $.showMsg("λޱע豸!");
            }
        }
    });

    function doSearch() {
        $('#monitor-tab-grid').datagrid('loadData', {total: 0, rows: []});
        $('#monitor-tab-grid').datagrid('load', getQueryParams());
        getdata();
    }

    //ѯ
    function getQueryParams() {
        var sParam = {};
        sParam.layerSeq = 1;
        sParam.LIKEmc = $('#LIKEsbmc').textbox('getText');
        sParam.sblb = $('#lb').combobox('getValue');
        if($('#state').combobox('getValue')=="0")//߰is null
        {
            sParam.tableparam ="and (state =20 or state is null) ";
        }
        else {
            sParam.state = String($('#state').combobox('getValue'));
        }
//    console.log(sParam);
        return sParam;
    }

    //б
    function initGrid() {
        //ͳ豸
        datagrid = $('#monitor-tab-grid').datagrid({
            url: 'szMapStatisAction!getMapDeviceStatusData.do',
            queryParams: getQueryParams(),
            rownumbers: true,
            columns: [[
                {field: 'name', title: '豸', width: 120},
                {
                    field: 'status', title: '״̬', width: 40,
                },
                {field: 'xzqh', title: '',hidden:true, width: 90},
                {field: 'xzmc', title: '', width: 60},
                {field: 'ip', title: 'ip', width: 60},
                {field: 'jd', title: '', width: 60},
                {field: 'wd', title: 'γ', width: 60}
            ]]
        });
        getdata();
    }

    //ѡ
    function getdata() {
        $.ajax({
            type: 'post',
            dateType: 'json',
            url: 'szMapStatisAction!getDeviceStatusStatis.do',
            data: getQueryParams(),
            success: function (res) {
                renderTable(res);
            }
        });
    }

    function renderTable(res) {
        $("#searchGridList").html();
        var table = '';
        if (res) {
            var rows = res;
            table += '<tr>\
				<td>' + transformateEmpty(rows.total) + '</td>\
				<td>' + transformateEmpty(rows.normal) + '</td>\
				<td>' + transformateEmpty(rows.abnormal) + '</td>\
				<td>' + transformateEmpty(rows.repairing) + '</td>\
				<td>' + transformateEmpty(rows.repaired) + '</td>\
				<tr>'
        } else {
            table += '<tr> <td colspan="8"></td> <tr>';

        }
        $("#searchGridList").html(table);
    }

    function transformateEmpty(str) {
        if (!str || str == null || str == "null") {
            return "-";
        }
        return str;
    }
</script>
</body>
</html>	
